@extends('backend.admin-master')

@section('site-title')
    {{__('Service Single Settings')}}
@endsection
@section('content')
    <div class="col-lg-12 col-ml-12 padding-bottom-30">
        <div class="row">
            <div class="col-lg-12">
                <div class="margin-top-40"></div>
                @include('backend/partials/message')
                @if($errors->any())
                    <div class="alert alert-danger">
                        <ul>
                            @foreach($errors->all() as $error)
                                <li>{{$error}}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
            </div>
            <div class="col-lg-12 mt-t">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title">{{__('Service Single Settings')}}</h4>
                        <form action="{{route('admin.services.single.page.settings')}}" method="post" enctype="multipart/form-data">
                            @csrf
                            <nav>
                                <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                    @foreach($all_languages as $key => $lang)
                                    <a class="nav-item nav-link @if($key == 0) active @endif" data-toggle="tab" href="#nav-home-{{$lang->slug}}" role="tab"  aria-selected="true">{{$lang->name}}</a>
                                    @endforeach
                                </div>
                            </nav>
                            <div class="tab-content margin-top-30" id="nav-tabContent">
                                @foreach($all_languages as $key => $lang)
                                <div class="tab-pane fade @if($key == 0) show active @endif" id="nav-home-{{$lang->slug}}" role="tabpanel">
                                    <div class="form-group">
                                        <label for="service_single_page_{{$lang->slug}}_category_title">{{__('Category Title')}}</label>
                                        <input type="text" name="service_single_page_{{$lang->slug}}_category_title" value="{{get_static_option('service_single_page_'.$lang->slug.'_category_title')}}" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="service_single_page_{{$lang->slug}}_recent_services_title"><strong>{{__('Recent Services')}}</strong></label>
                                        <input type="text" class="form-control" name="service_single_page_{{$lang->slug}}_recent_services_title" value="{{get_static_option('service_single_page_'.$lang->slug.'_recent_services_title')}}">

                                    </div>
                                    <div class="form-group">
                                        <label for="service_single_page_{{$lang->slug}}_search_placeholder_text">{{__('Search Placeholder Text')}}</label>
                                        <input type="text" name="service_single_page_{{$lang->slug}}_search_placeholder_text" value="{{get_static_option('service_single_page_'.$lang->slug.'_search_placeholder_text')}}" class="form-control" >
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">{{__('Update Settings')}}</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

